/**
 * Меняем локальные пути на ссылки в yastatic.
 */
const path = require('path');
const fs = require('fs');
const util = require('util');

const readdir = util.promisify(fs.readdir);
const readfile = util.promisify(fs.readFile);
const writefile = util.promisify(fs.writeFile);

const DIR = path.join(__dirname, '../out/static');
const qtoolsConfig = require(path.join(__dirname, '../.qtools.json'));
const VER = qtoolsConfig.registry.tag;
const APP = qtoolsConfig.abcServiceName;
const YASTATIC_URL = `https://yastatic.net/s3/front-maps-static/${APP}/${VER}/out/static/`;

(async function rewrite(dir) {
    if (!VER) {
        throw new Error('VERSION is undefined');
    }
    const dirents = await readdir(dir, {withFileTypes: true});
    const promises = [];
    dirents.forEach((dirent) => {
        const direntPath = path.join(dir, dirent.name);

        if (dirent.isDirectory()) {
            rewrite(direntPath);
        } else if (/\.html$/g.test(direntPath)) {
            promises.push(readAndRewriteHtml(direntPath));
        } else if (/\.css$/g.test(direntPath)) {
            promises.push(readAndRewriteCss(direntPath))
        }
    });
    await Promise.all(promises);
    console.log(`[done] ${dir}`);
})(DIR);

async function readAndRewriteHtml(filepath) {
    const file = await readfile(filepath, 'utf8');
    const enVersion = filepath.includes('/en/');
    const content = file
        .replace(/assets\/css/g, `${YASTATIC_URL}assets/css`)
        .replace(/assets\/img/g, `${YASTATIC_URL}assets/img`)
        .replace(/assets\/js/g, `${YASTATIC_URL}assets/js`)
        .replace(/href="([^/"]+)\.html"/g, `href="${enVersion ? '/' : '/'}$1"`);

    await writefile(filepath, content, 'utf8');
}

async function readAndRewriteCss(filepath) {
    const file = await readfile(filepath, 'utf8');
    const content = file
        .replace(/\.\.\/fonts/g, `${YASTATIC_URL}assets/fonts`)
        .replace(/\.\.\/img/g, `${YASTATIC_URL}assets/img`);

    await writefile(filepath, content, 'utf8');
}
