(function() {
    const auth = document.querySelector('[data-id="auth"]');
    const demo = document.querySelectorAll('[data-id="demo"]');
    const form = document.querySelector('#req-demo');
    const button = form.querySelector('.button_primary');

    const retpath = encodeURIComponent(document.location.origin);
    const tld = document.location.hostname.endsWith('.com') ? 'com' : 'ru';
    auth.href = 'https://passport.yandex.' + tld + '/auth/list?retpath=' + retpath + '&backpath=' + retpath;

    function onDemoClick(event) {
        event.preventDefault();
        form.scrollIntoView({behavior: 'smooth', block: 'center', inline: 'nearest'})
    }

    for (let i = 0; i < demo.length; i++) {
        demo[i].addEventListener('click', onDemoClick);
    }

    button.addEventListener('click', send);
    form.addEventListener('submit', function(event) {
        event.preventDefault();
        send();
        return false;
    });

    let lock = false;
    function send() {
        if (lock) {
            return;
        }
        lock = true;

        const fields = ['name', 'email', 'phone', 'company_name', 'cars_count'];
        let data = [];
        let isValid = false;

        for (let i = 0; i < fields.length; i++) {
            const name = fields[i];
            const value = form.querySelector('[data-id="' + name + '"]').value;

            if ((name === 'email' || name === 'phone') && value) {
                isValid = true;
            }

            data.push({
                caption: name,
                value: value,
            });
        }

        if (!isValid) {
            lock = false;
            return;
        }

        button.innerText = 'Отправка...';

        fetch('/web-api/request/demo', {method: 'POST', body: JSON.stringify(data)})
            .then((req) => req.json())
            .then((data) => {
                button.innerText = data.ok ? 'Отправлено, скоро мы свяжемся с вами' : 'Упс... Попробуйте позже';
                lock = false;
            })
            .catch(() => {
                button.innerText = 'Упс... Попробуйте позже';
                lock = false;
            });
    }
})()
