import { IncomingMessage, ServerResponse } from 'node:http';

import { RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { fetchPage } from 'lib/api/fetchPage/fetchPage';
import { getCSP } from 'lib/csp/getCSP';
import { isReqRefererTrusted } from 'lib/request/isReqRefererTrusted/isReqRefererTrusted';
import { sendResHtml } from 'lib/response/sendResHtml/sendResHtml';
import { setResNoCacheHeaders } from 'lib/response/setResNoCacheHeaders/setResNoCacheHeaders';
import { setResSecurityHeaders } from 'lib/response/setResSecurityHeaders/setResSecurityHeaders';

export async function errorPageController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    const content = await fetchPage('index_502.html', { req, logger });

    if (content.statusCode === HttpStatusCode.NOT_FOUND) {
        return sendResHtml(res, HttpStatusCode.NOT_FOUND, 'Frontend not found');
    } else if (content.statusCode !== HttpStatusCode.OK) {
        return sendResHtml(res, HttpStatusCode.INTERNAL_SERVER_ERROR, 'HTTP500: Frontend Server Error');
    }

    const csp = getCSP(req);

    setResSecurityHeaders(res, csp, isReqRefererTrusted(req));
    setResNoCacheHeaders(res);

    sendResHtml(res, HttpStatusCode.INTERNAL_SERVER_ERROR, content.body);
}
