import { IncomingMessage, ServerResponse } from 'node:http';

import { RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { createStartrekTicket } from 'lib/api/createStartrekTicket/createStartrekTicket';
import { parseReqStream } from 'lib/request/parseReqStream/parseReqStream';
import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function formController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    const data = await parseReqStream<Array<{ caption: string; value: string }>>(req);

    logger.warn({ formdata: data }, '[FormData] %s', req.url);

    if (data && data.length) {
        const description = data
            .map((item: any) => {
                if (item && item.caption && item.value) {
                    return '**' + item.caption + '**' + ': ' + item.value;
                }

                return '';
            })
            .filter(Boolean)
            .join('\n');

        const ticket = await createStartrekTicket(
            {
                type: 'task',
                queue: process.env.DM_PROFILE === 'test' ? 'TEST' : 'DRIVEMATICSBTOB',
                summary: 'Landing Form ' + new Date().toISOString(),
                description,
            },
            { logger },
        );

        if (ticket) {
            return sendResJson(res, HttpStatusCode.OK, { ok: 1 });
        }
    }

    return sendResJson(res, HttpStatusCode.BAD_REQUEST, { error: 1 });
}
