import { IncomingMessage, ServerResponse } from 'node:http';

import { RequestHandlerOptions } from 'types';

import { DM_VERSION } from 'consts/consts';
import { HttpStatusCode } from 'consts/HttpStatusCode';

import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function versionController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    return sendResJson(res, HttpStatusCode.OK, {
        code: HttpStatusCode.OK,
        data: {
            version: DM_VERSION,
        },
    });
}
