import { IncomingMessage } from 'node:http';

import { getDrivematicsCSP } from 'lib/csp/getDrivematicsCSP';
import { getVlootkitCSP } from 'lib/csp/getVlootkitCSP';
import { getReqHostService } from 'lib/request/getReqHostService/getReqHostService';
import { getReqHostTld } from 'lib/request/getReqHostTld/getReqHostTld';

export function getCSP(req: IncomingMessage): string {
    const service = getReqHostService(req);
    const tld = getReqHostTld(req);

    if (service === 'vlootkit') {
        return getVlootkitCSP(tld);
    }

    return getDrivematicsCSP(tld);
}
