import { CSP } from 'lib/csp/helpers/CSP';
import { getNonceCSP } from 'lib/csp/helpers/getNonceCSP';
import { addYaErrorBoosterCSP } from 'lib/csp/parts/addYaErrorBoosterCSP';
import { addYaMapsCSP } from 'lib/csp/parts/addYaMapsCSP';
import { addYaMetrikaCSP } from 'lib/csp/parts/addYaMetrikaCSP';
import { HostTld } from 'lib/request/getReqHostTld/getReqHostTld';

const CDN_NONCE = getNonceCSP('__APP_CDN__ = "https://yastatic.net/s3/drivematics/"');
const CDN_IGNORE_NONCE = getNonceCSP('__APP_CDN__ = false');

const DM_PROFILE = process.env.DM_PROFILE;

export function getDrivematicsCSP(tld: HostTld): string {
    const csp = new CSP();

    // csp.reportURI().url(`https://csp.yandex.net/csp?from=drivematics.web&project=drivematics&yandex_login=${login}&yandexuid=${uid}`);
    csp.reportURI().url('https://csp.yandex.net/csp?from=drivematics.web&project=drivematics');

    csp.default().none();

    csp.baseURI().none();

    csp.script()
        .self()
        .url('yastatic.net')
        .nonce(CDN_NONCE)
        .nonce(CDN_IGNORE_NONCE)
        .reportSample();

    csp.style()
        .self()
        .unsafeInline()
        .url('yastatic.net')
        .reportSample();

    csp.font()
        .self()
        .url('yastatic.net');

    csp.connect().self();

    csp.child().self();
    csp.frame().self();

    csp.img()
        .self()
        .data() // ?
        .blob() // user docs photos
        .url('sda-photos.s3-private.mds.yandex.net') // camera event photos
        .url('carsharing-acceptances.s3.mds.yandex.net') // car acceptances/damages photos
        .url('carsharing-acceptances.s3.yandex.net') // car acceptances/damages photos
        .url('carsharing.s3.yandex.net') // car models photos
        .url('avatars.mds.yandex.net') // passport user avatar
        .url('favicon.yandex.net') // favicon
        .url('yastatic.net');

    if (DM_PROFILE === 'test') {
        csp.img().url('carsharing.s3.mdst.yandex.net'); // car models photos
    }

    csp.media()
        .self()
        .data() // ?
        .blob() // ?
        .url('sda-videos.s3-private.mds.yandex.net') // camera event videos
        .url('yastatic.net');

    addYaErrorBoosterCSP(csp);
    addYaMetrikaCSP(csp, true);
    addYaMapsCSP(csp, tld);

    return csp.toString();
}
