import { CSP } from 'lib/csp/helpers/CSP';
import { addYaMetrikaCSP } from 'lib/csp/parts/addYaMetrikaCSP';

export function getDrivematicsLandingCSP(): string {
    const csp = new CSP();

    // csp.reportURI().url(`https://csp.yandex.net/csp?from=drivematics.landing&project=drivematics&yandex_login=${login}&yandexuid=${uid}`);
    csp.reportURI().url('https://csp.yandex.net/csp?from=drivematics.landing&project=drivematics');

    csp.default().none();

    csp.baseURI().none();

    csp.script()
        .url('drivematics.s3.yandex.net')
        .nonce('sha256-g7jjsIpyzqpSMNSTW5ImvqutYIcYhe8PKppYkfZCSfs=') // ya metrika
        .reportSample();

    csp.style()
        .url('drivematics.s3.yandex.net')
        .reportSample();

    csp.font().url('yastatic.net');

    csp.img()
        .self()
        .data()
        .url('drivematics.s3.yandex.net');

    csp.connect()
        .self()
        .url('drivematics.s3.yandex.net')
        .url('yastatic.net');

    csp.child().none();

    addYaMetrikaCSP(csp, true);

    return csp.toString();
}
