import { IncomingMessage } from 'node:http';

import { getDrivematicsLandingCSP } from 'lib/csp/getDrivematicsLandingCSP';
import { getVlootkitLandingCSP } from 'lib/csp/getVlootkitLandingCSP';
import { getReqHostService } from 'lib/request/getReqHostService/getReqHostService';

export function getLandingCSP(req: IncomingMessage): string {
    const service = getReqHostService(req);

    if (service === 'vlootkit') {
        return getVlootkitLandingCSP();
    }

    return getDrivematicsLandingCSP();
}
