import { CSP } from 'lib/csp/helpers/CSP';

export function getVlootkitLandingCSP(): string {
    const csp = new CSP();

    csp.reportURI().url('https://csp.yandex.net/csp?from=vlootkit.landing&project=drivematics');

    csp.default().none();

    csp.baseURI().none();

    csp.script()
        .url('vlootkit-frontend.s3.eu-central-1.amazonaws.com')
        .reportSample();

    csp.style()
        .url('vlootkit-frontend.s3.eu-central-1.amazonaws.com')
        .reportSample();

    csp.font().url('yastatic.net');

    csp.img()
        .self()
        .data()
        .url('vlootkit-frontend.s3.eu-central-1.amazonaws.com');

    csp.connect()
        .self()
        .url('vlootkit-frontend.s3.eu-central-1.amazonaws.com')
        .url('yastatic.net');

    csp.child().none();

    return csp.toString();
}
