import { CSP } from 'lib/csp/helpers/CSP';
import { HostTld } from 'lib/request/getReqHostTld/getReqHostTld';

// https://yandex.ru/dev/maps/jsapi/doc/2.1/dg/concepts/load.html
export function addYaMapsCSP(csp: CSP, tld: HostTld): void {
    const mapsTld = tld === 'ru' ? 'ru' : 'com';

    csp.img()
        .data()
        .url('yandex.ru')
        .url('yandex.com')
        .url(`api-maps.yandex.${mapsTld}`)
        .url('api-maps.yandex.ru')
        .url('*.maps.yandex.net');

    csp.child().blob().url(`api-maps.yandex.${mapsTld}`).url('api-maps.yandex.ru');

    csp.frame().blob().url(`api-maps.yandex.${mapsTld}`).url('api-maps.yandex.ru');

    csp.script()
        .unsafeEval()
        .url(`api-maps.yandex.${mapsTld}`)
        .url('api-maps.yandex.ru')
        .url('*.maps.yandex.net')
        .url('yastatic.net');

    csp.connect()
        .url('yandex.ru')
        .url('yandex.com')
        .url(`api-maps.yandex.${mapsTld}`)
        .url('api-maps.yandex.ru')
        .url('*.maps.yandex.net');

    csp.style().blob();
}
