import { CSP } from 'lib/csp/helpers/CSP';

// https://yandex.ru/support/metrica/code/install-counter-csp.html
export function addYaMetrikaCSP(csp: CSP, webvisor: boolean = false): void {
    csp.img().url('mc.yandex.ru').url('mc.yandex.com');

    csp.script().url('mc.yandex.ru').url('mc.yandex.com').url('yastatic.net');

    csp.connect().url('mc.yandex.ru').url('mc.yandex.com').url('mc.yandex.md').url('yandexmetrica.com:*');

    // ya metrika webvisor
    if (webvisor) {
        csp.child().blob().url('mc.yandex.ru').url('mc.yandex.com');
        csp.frame().blob().url('mc.yandex.ru').url('mc.yandex.com');
    }
}
