import { IncomingHttpHeaders, IncomingMessage } from 'node:http';

export function getReqHeaderStr(req: IncomingMessage, name: keyof IncomingHttpHeaders): string | undefined {
    const value = req.headers[name];

    return Array.isArray(value) ? value[0] : value;
}
