import { IncomingMessage } from 'node:http';

import { getReqHeaderStr } from 'lib/request/getReqHeaderStr/getReqHeaderStr';

export function getReqHost(req: IncomingMessage): string {
    return getReqHeaderStr(req, 'x-forwarded-host') || getReqHeaderStr(req, 'x-host') || req.headers.host || 'UNKNOWN';
}
