import { IncomingMessage } from 'node:http';

import { getReqHost } from 'lib/request/getReqHost/getReqHost';

const vlootkitRegExp = /^(.+\.)?vlootkit\.(com|cz)$/;

export type HostService = 'vlootkit' | 'drivematics';

export function getReqHostService(req: IncomingMessage): HostService {
    const host = getReqHost(req);

    return vlootkitRegExp.test(host) ? 'vlootkit' : 'drivematics';
}
