import { IncomingMessage } from 'node:http';

import { getReqHost } from 'lib/request/getReqHost/getReqHost';

const DEFAULT_TLD = 'com';

const hostTldRegExp = /\.yandex\.(ru|com|eu)$/;

export type HostTld = 'ru' | 'com' | 'eu';

export function getReqHostTld(req: IncomingMessage): HostTld {
    const host = getReqHost(req);
    const data = host.match(hostTldRegExp);

    return ((data && data[1]) || DEFAULT_TLD) as HostTld;
}
