import { IncomingMessage } from 'node:http';

const trustedRefererRegExp = /^https:\/\/((.+\.)?drivematics.yandex.(ru|com|eu)|webvisor\.com)\//;

export function isReqRefererTrusted(req: IncomingMessage): boolean {
    if (req.headers.referer) {
        return trustedRefererRegExp.test(req.headers.referer);
    }

    return false;
}
