import { ServerResponse } from 'node:http';

import { HttpStatusCode } from 'consts/HttpStatusCode';

export function sendResJson(res: ServerResponse, statusCode: HttpStatusCode, content: Record<string, any>): void {
    res.statusCode = statusCode;
    res.setHeader('Content-Type', 'application/json');
    res.end(JSON.stringify(content));
}
