##### -------------------------------------------------------------------------------------------------- #####
##### Port from https://github.yandex-team.ru/toolbox/dockerfiles-ubuntu/blob/master/src/full.Dockerfile #####
##### -------------------------------------------------------------------------------------------------- #####

# Skip any interactive post-install configuration steps
export DEBIAN_FRONTEND=noninteractive;

apt-get clean;

# Install Base package with internal keyrings
apt-get update \
  --ignore-missing --allow-unauthenticated --allow-insecure-repositories;
apt-get install \
  --no-install-recommends --no-install-suggests --assume-yes \
  yandex-ubuntu-archive-apt \
  yandex-archive-keyring \
  yandex-search-common-apt;

# Install base dependencies required for downloading and installing public keys
# Install HTTPS transport for apt
# Common CA certificates
# Tool for transferring data with URL syntax (required to obtain keys)
# Tool for secure communication and data storage (required to install authentication keys)
apt-get update --fix-missing;
apt-get install \
  --no-install-recommends --no-install-suggests --assume-yes \
  apt-transport-https \
  ca-certificates \
  curl \
  lsb-release \
  gnupg;

# Install certificates
# YandexInternalRootCA certificate
# Install Intermediate SSL-certificate
mkdir -p /usr/local/share/ca-certificates/;
curl https://crls.yandex.net/YandexInternalRootCA.crt > /usr/local/share/ca-certificates/YandexInternalRootCA.crt;
curl https://crls.yandex.net/allCAs.pem > /etc/ssl/certs/allCAs.pem;
curl https://crls.yandex.net/allCAs.pem >> /etc/ssl/certs/ca-certificates.crt;

update-ca-certificates;

# Install time zones and locales
# National language (locale) data
# Time zone and daylight-saving time data
apt-get install \
  --no-install-recommends --no-install-suggests --assume-yes \
  locales \
  tzdata;

# Install needed to python packages
# Essential for building Debian packages (g++, gcc, make and others)
# Minimal subset of the Python language
# Python package installer
apt-get install \
  --no-install-recommends --no-install-suggests --assume-yes \
  build-essential \
  coreutils \
  python-dev \
  python-minimal;

# Install dependencies for debugging and scripts
# DNS lookup utility
# An interactive process viewer
# Collection of utilities for networking and traffic control,
# including ip required for L3 balancers
# Ping command
# Default pager program
# Manual pages
# Easy-to-use text editor
# Utility which reads and writes data across network connections using TCP or UDP protocol
# Stream editor
# System call tracer
# A process control system (to control two or more processes in one container)
# Utility to dump the traffic on a network
# Hard-to-use text editor
apt-get install \
  --no-install-recommends --no-install-suggests --assume-yes \
  host \
  htop \
  iproute2 \
  iputils-ping \
  less \
  man \
  nano \
  netcat-openbsd \
  sed \
  strace \
  supervisor \
  tcpdump \
  vim;

# Setup Europe/Moscow as the default timezone
echo 'Europe/Moscow' > /etc/timezone;
[ -s /usr/share/zoneinfo/Europe/Moscow ] && ln -fs /usr/share/zoneinfo/Europe/Moscow /etc/localtime;
if [ -L /usr/share/zoneinfo/UTC ] && [ -f /usr/share/zoneinfo/Etc/UTC ]; then ln -fs /usr/share/zoneinfo/Etc/UTC /usr/share/zoneinfo/UTC; fi;
dpkg-reconfigure --frontend noninteractive tzdata;

# Generate the en_US.UTF-8 locale
locale-gen en_US.UTF-8;

# Setup en_US.UTF-8 as the default locale
export LANG=en_US.UTF-8;
cat >> /etc/bash.bashrc << 'EOF'
export LANG=en_US.UTF-8
EOF

# Setup command prompt
cp /root/.bashrc /.bashrc;

##### -------------------------------------------------------------------------------------------------- #####
##### Port from https://github.yandex-team.ru/toolbox/dockerfiles-nodejs/blob/master/src/full.Dockerfile #####
##### -------------------------------------------------------------------------------------------------- #####

# Download Node.js package specified version
curl -o /tmp/nodejs_$NODEJS_VERSION.deb https://deb.nodesource.com/node_$NODEJS_MAJOR.x/pool/main/n/nodejs/nodejs_$NODEJS_VERSION-1nodesource1_amd64.deb;

apt-get update --fix-missing;

# Install build essential which is used to install npm dependencies with node-gyp
apt-get install \
  --no-install-recommends --no-install-suggests --assume-yes \
  build-essential;

# Install Node.js and npm
dpkg -i /tmp/nodejs_$NODEJS_VERSION.deb;

# Update npm to the latest minor version
npm install \
  --global --registry=http://registry.npmjs.org/ \
  npm@$(npm --version | cut --delimiter='.' --fields=1);

# Use Yandex internal npm registry by default
npm --global config set registry=https://npm.yandex-team.ru/;

# Necessary for building native modules
npm --global config set user root;

export npm_config_cache=$(mktemp -d);

# Install ICU data
FULL_ICU_PREFER_NPM=true npm install --global full-icu;

rm -rf $npm_config_cache;

# Give full access to the /tmp, which is necessary for npm
chmod 1777 /tmp;

cat >> /etc/bash.bashrc << 'EOF'
export NODE_EXTRA_CA_CERTS=/usr/local/share/ca-certificates/YandexInternalRootCA.crt
export NODE_ICU_DATA=/usr/lib/node_modules/full-icu
export NODE_PATH=/usr/lib/node_modules/
EOF

## Create logs dir
export YANDEX_LOGS_DIR=/var/log/yandex;
mkdir -p $YANDEX_LOGS_DIR;
chmod 1777 $YANDEX_LOGS_DIR;

# Clean up packages required only for build to reduce image size
apt-get remove \
  --assume-yes \
  python-dev;
