#!/usr/bin/env bash

set -ex

# prepare
rm -rf ./tmp ./dist

# build
npm run build

# combine
mkdir ./tmp
mkdir ./tmp/drivematics-server
cp -R ./dist ./tmp/drivematics-server/dist
cp -R ./node_modules ./tmp/drivematics-server/node_modules
cp package.json ./tmp/drivematics-server/package.json
cp package-lock.json ./tmp/drivematics-server/package-lock.json

# deploy
ya upload --tar --type=OTHER_RESOURCE \
    --description='Drivematics Server build' \
    --attr app=drivematics-server \
    --owner=DRIVEMATICS_FRONTEND \
    ./tmp/drivematics-server \
    --json-output

# cleanup
rm -rf ./tmp

# info
echo 'Testing stage: https://deploy.yandex-team.ru/stages/drivematics-testing/edit/du-frontend#disks'
echo 'Production stage: https://deploy.yandex-team.ru/stages/drivematics-production/edit/du-frontend#disks'
