const { Provider: AwacsProvider } = require('@yandex-int/awacs-api');
const tokenator = require('@yandex-int/tokenator');

const { logger } = require('../lib/logger');

async function getAwacsToken() {
    let awacsToken = process.env.AWACS_TOKEN;

    if (!awacsToken) {
        let tokenatorTokens = await tokenator(['awacs']);
        awacsToken = tokenatorTokens.awacs;
    }

    return awacsToken;
}

function getUpstreamMeta(name) {
    return {
        namespaceId: 'testing.fleetmatic.yandex.ru',
        id: name,
    };
}

async function removeUpstream(awacs, name) {
    let upstreamMeta = getUpstreamMeta(name);
    let upstreamData;

    try {
        let result = await awacs.getUpstream(upstreamMeta);
        upstreamData = result.upstream;
    } catch (e) {
        // noop
        logger.warn(`No '${name}' upstreams found. Error:`, e);
    }

    if (upstreamData && upstreamData.meta) {
        await awacs.removeUpstream({
            ...upstreamMeta,
            version: upstreamData.meta.version,
        });
    }
}

async function main() {
    let prNumber = Number(process.env.CI_PULL_REQUEST_ID);

    if (!prNumber) {
        throw new Error('CI_PULL_REQUEST_ID env variable is not specified');
    }

    let awacsToken = await getAwacsToken();
    let awacs = new AwacsProvider({ token: awacsToken });

    let slug = 'pr-' + prNumber;

    try {
        await removeUpstream(awacs, slug);

        logger.info(`AWACS ${slug} removed successfully`);
        logger.info('Please wait ~10min to deploy configuration for all balancers');
    } catch (e) {
        logger.error(`AWACS ${slug} remove failed`);

        throw e;
    }
}

main().catch((error) => {
    logger.error(error);
    process.exit(1);
});
