#!/usr/bin/env bash

set -x

export PATH=$ARCADIA_PATH:$PATH

cd drive/frontend/services/drivematics

RESULT=$(node .config/ci/find-cache.js)
RESOURCE_ID=$(echo $RESULT | ya tool jq -r '.id // ""')
PACKAGE_JSON_MD5=$(echo $RESULT | ya tool jq -r '.package_json_md5')

if [ -z "$RESOURCE_ID" ]; then
  npm ci --no-audit
  RESULT=$(ya upload --tar --type=NODEJS_MODULE --description='Node modules cache for Drivematics' --attr app=drivematics --attr package_json_md5=$PACKAGE_JSON_MD5 --owner=DRIVEMATICS_FRONTEND ./node_modules --json-output)
  RESOURCE_ID=$(echo $RESULT | ya tool jq -r '.resource_id');
fi

touch $RESULT_EXTERNAL_RESOURCES_PATH/$RESOURCE_ID
