#!/usr/bin/env bash

set +x

if [[ -n "$ROBOT_SSH_KEY" ]]; then
    echo "Start to prepare ssh key"
    cat <<< "$ROBOT_SSH_KEY" > ~/.ssh/id_rsa
    chmod 400 ~/.ssh/id_rsa
    ssh-add ~/.ssh/id_rsa
    echo "Finish to prepare ssh key"
fi

set -x

TASK_NAME=$1
NODE_MODULES_ARTEFACT_PATH=$2
TASK_RESULT_PATH=$3

export PATH=$(dirname $ARC_BIN):$ARCADIA_PATH:$PATH

cd drive/frontend/services/drivematics

if [[ -n "$NODE_MODULES_ARTEFACT_PATH" ]]; then
    tar -C ./ -xf $NODE_MODULES_ARTEFACT_PATH
else
    npm ci --no-audit
fi

npm run $TASK_NAME
TASK_EXIT_STATUS=$?

if [[ -n "$TASK_RESULT_PATH" ]]; then
    mv ./$TASK_RESULT_PATH $RESULT_RESOURCES_PATH/
fi

exit $TASK_EXIT_STATUS
