const LANGS = ['en', 'cs', 'ru'];

if (!process.env.LANG || !LANGS.includes(process.env.LANG)) {
    // fix lang env variable
    process.env.LANG = 'en';
}

const DM_SERVICE = process.env.DM_SERVICE === 'vlootkit' ? 'vlootkit' : 'drivematics';

function getBackendHost(service) {
    const BASES = {
        // 'vlootkit': 'vlootkit.com',
        vlootkit: 'drivematics.yandex.ru',
        drivematics: 'drivematics.yandex.ru',
    };

    const base = BASES[service];
    const cluster = process.env.DM_BACKEND_CLUSTER ?? 'testing';

    if (cluster === 'prod') {
        return base;
    }

    return cluster + '.' + base;
}

module.exports = {
    lang: process.env.LANG,
    service: DM_SERVICE,
    backendHost: getBackendHost(DM_SERVICE),
};
