const configs = {
    all: {
        plugins: ['drivematics'],
        rules: {
            'drivematics/only-absolute-paths': ['warn', { baseUrl: 'src', excludes: ['request-helper'] }],
        },
        overrides: [
            {
                files: ['**/*.i18n.ts'],
                rules: {
                    'drivematics/empty-translations': ['error', { languages: ['ru'] }],
                },
            },
        ],
    },
};

const rules = {
    'empty-translations': require('./rules/emptyTranslations'),
    'only-absolute-paths': require('./rules/onlyAbsolutePaths'),
};

module.exports = { configs, rules };
