const ERROR_MESSAGE_ID = 'errorMessage';
const messages = {
    [ERROR_MESSAGE_ID]: "The translation key '{{key}}' cannot be empty",
};

function checkValue(node, context, value, key) {
    if (!value) {
        context.report({
            node,
            messageId: ERROR_MESSAGE_ID,
            data: { key },
        });
    }
}

const create = (context) => {
    function checkNode(node) {
        const { languages } = context.options[0];

        const key = node.key.name;

        if (languages.includes(key) && node.parent.parent.type === 'Property') {
            const propType = node.value.type;

            if (propType === 'Literal') {
                checkValue(node, context, node.value.value, key);
            }

            if (propType === 'ObjectExpression') {
                node.value.properties.forEach(({ key, value }) => {
                    checkValue(node, context, value.value, key.name);
                });
            }
        }
    }

    return {
        Property: checkNode,
    };
};

module.exports = {
    create,
    name: 'empty-translations',
    meta: {
        type: 'suggestion',
        docs: {
            description: 'Empty translations',
        },
        fixable: false,
        schema: [
            {
                type: 'object',
                properties: {
                    languages: {
                        type: 'array',
                        items: {
                            type: 'string',
                        },
                    },
                },
                additionalProperties: false,
            },
        ],
        messages,
    },
};
