require('./register');

const path = require('path');
const config = require('@yandex-int/frontend-hermione-config/get-hermione-conf')('drivematics');

const LOCAL_GRID = 'http://localhost:4444/wd/hub';
const CHROME_VERSION = '67.0';
const UA_ANDROID =
    'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.77 Mobile Safari/537.36';
const UA_IPHONE =
    'Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1';

const isLocalGrid = Boolean(process.env.DM_LOCAL_GRID);

const MOBILE_CHROME = {
    screenshotDelay: 600,
    desiredCapabilities: {
        browserName: 'chrome',
        version: CHROME_VERSION,
        chromeOptions: {
            mobileEmulation: {
                userAgent: UA_ANDROID,
                deviceMetrics: {
                    width: 360,
                    height: 640,
                    pixelRatio: 1.0,
                },
            },
        },
    },
    meta: { platform: 'mobile' },
};

const MOBILE_CHROME_IOS = {
    screenshotDelay: 600,
    desiredCapabilities: {
        browserName: 'chrome',
        version: CHROME_VERSION,
        chromeOptions: {
            mobileEmulation: {
                userAgent: UA_IPHONE,
                deviceMetrics: {
                    width: 320,
                    height: 638,
                    pixelRatio: 1.0,
                },
            },
        },
    },
    meta: { platform: 'mobile' },
};

config.screenshotsDir = (test) => {
    function getSourceFilePath(test) {
        let list = [];
        let current = test.parent;

        while (current) {
            if (current.title) {
                list.push(current.title);
            }

            current = current.parent;
        }

        return path.normalize(path.join(path.dirname(test.file), '../../../src', ...list.reverse()));
    }

    return path.join(getSourceFilePath(test), '__screens__', test.title, test.browserId);
};

config.plugins['@yandex-int/frontend-hermione-config/plugins/html-reporter'].metaInfoBaseUrls.file =
    'https://a.yandex-team.ru/arc/trunk/arcadia/drive/frontend/?from_pr=' + process.env.CI_PULL_REQUEST_ID;

// TODO: enable testcop. https://testcop.si.yandex-team.ru/config/new
config.plugins['@yandex-int/frontend-hermione-config/plugins/hermione-muted-tests'].enabled = false;
config.plugins['@yandex-int/frontend-hermione-config/plugins/json-reporter'].enabled = true;

// disable collecting usage stats into clickhouse db. sec-01dc1dxehkb9ehssp4tyytz29e
config.plugins['@yandex-int/frontend-hermione-config/plugins/hermione-usage-stats'].enabled = false;

config.plugins['hermione-storybook/plugin'] = {
    enabled: true,
    storybookUrl: process.env.CI ? `https:${require('@yandex-int/static-uploader').staticPath}` : '/',
};

Object.assign(config.browsers, {
    'chrome-phone': MOBILE_CHROME,
    'ios-chrome-mobile-touch': MOBILE_CHROME_IOS,

    'chrome-360': MOBILE_CHROME,
    'chrome-320': MOBILE_CHROME_IOS,

    'chrome-360-landscape': {
        screenshotDelay: 600,
        desiredCapabilities: {
            browserName: 'chrome',
            version: CHROME_VERSION,
            chromeOptions: {
                mobileEmulation: {
                    userAgent: UA_ANDROID,
                    deviceMetrics: {
                        width: 640,
                        height: 360,
                        pixelRatio: 1.0,
                    },
                },
            },
        },
        meta: { platform: 'mobile' },
    },
    'chrome-320-landscape': {
        screenshotDelay: 600,
        desiredCapabilities: {
            browserName: 'chrome',
            version: CHROME_VERSION,
            chromeOptions: {
                mobileEmulation: {
                    userAgent: UA_IPHONE,
                    deviceMetrics: {
                        width: 638,
                        height: 320,
                        pixelRatio: 1.0,
                    },
                },
            },
        },
        meta: { platform: 'mobile' },
    },
});

config.system = {
    fileExtensions: ['.js', '.ts'],
};

config.gridUrl = isLocalGrid ? LOCAL_GRID : config.gridUrl;
config.retry = 1;

config.pageLoadTimeout = 100000;
config.httpTimeout = 60000;
config.sessionQuitTimeout = 60000;
config.sessionRequestTimeout = 120000;
config.takeScreenshotOnFailsTimeout = 10000;
config.browsers['linux-firefox'].desiredCapabilities.browserVersion = '67.0';
config.browsers['linux-chrome'].desiredCapabilities.browserVersion = '91.0';

config.sets = {
    // mobile: {
    //     browsers: ['chrome-320', 'chrome-360'],
    //     files: ['.config/hermione/story2hermione/story2hermione.ts'],
    // },
    desktop: {
        browsers: ['linux-chrome'],
        files: ['.config/hermione/story2hermione/story2hermione.ts'],
    },
};

module.exports = config;
