const path = require('path');
const glob = require('glob');
const Module = require('module');

require('../../consts');

const BASE_PATH = path.resolve(path.join(__dirname, '../../../src'));

Module._extensions['.css'] = () => {};
Module._extensions['.css'] = () => undefined;
Module._extensions['.svg'] = () => undefined;
Module._extensions['.ico'] = () => undefined;
Module._extensions['.png'] = () => undefined;

global.window = {};
global.Ya = {};

function camel2dashed(str) {
    let res = str.replace(/[A-Z]/g, (letter) => '-' + letter.toLowerCase());

    res = res.replace(/\d+/g, (letter) => '-' + letter.toLowerCase());

    if (res[0] === '-') {
        res = res.slice(1);
    }

    return res;
}

function storiesList(): string[] {
    // const stories = glob.sync(`${BASE_PATH}/**/*.story.tsx`);
    const stories = glob.sync(`${BASE_PATH}/@(pages|widgets|features|entities|shared)/**/*.story.@(tsx|ts)`);

    return stories.map((story) => path.join('.', story.slice(BASE_PATH.length + 1)));
}

function story2hermione() {
    console.log('[INFO] story2hermione starting... please wait');

    const start = Date.now();

    storiesList().forEach((fileName) => {
        let filePath = path.resolve(BASE_PATH, fileName);
        let fileDir = path.dirname(fileName);
        let componentPath = path.dirname(fileName).split('/');

        let story = require(filePath);

        if (story.default === undefined) {
            throw Error(`Could not find story: ${filePath}`);
        }

        let selector = story.default.hermioneSelector ? story.default.hermioneSelector : '#sb-container';
        let options = story.default.hermioneOptions;
        let title = story.default.title;
        let idPrefix = (title || fileDir).toLowerCase().replace(/\//g, '-');

        function describeComponentPath(path, fn) {
            let describeComponent = path.reverse().reduce((memo, val) => {
                return function () {
                    // eslint-disable-next-line no-undef
                    describe(val, memo);
                };
            }, fn);

            describeComponent();
        }

        describeComponentPath(componentPath, function () {
            Object.keys(story).forEach((caseName) => {
                if (caseName === 'default') {
                    return;
                }

                let { hermioneFn, hermionePlainFn, hermioneSelector, hermioneOptions } = story[caseName];

                let storySelector = hermioneSelector || selector;
                let storyHermioneOptions = hermioneOptions || options;

                // eslint-disable-next-line no-undef
                it(caseName, async function () {
                    const browser = this.browser;

                    // @ts-ignore
                    await browser.selectStory(`${idPrefix}--${camel2dashed(caseName)}`);
                    // @ts-ignore
                    await browser.$('body').moveTo({ xOffset: 1, yOffset: 1 });
                    // @ts-ignore
                    await browser.execute(() => document.body.classList.add('sb-hermione'));

                    await (hermionePlainFn
                        ? hermionePlainFn(browser, storySelector)
                        : browser.assertView('plain', storySelector, {
                              allowViewportOverflow: true,
                              compositeImage: true,
                              ...storyHermioneOptions,
                          }));

                    if (hermioneFn) {
                        await hermioneFn(browser, storySelector);
                    }
                });
            });
        });
    });

    console.log(`[INFO] story2hermione time: ${Date.now() - start}ms`);
}

story2hermione();
