import { TankerKeysetTranslatePayload, TankerLang } from './types';
import { MovaLang, MovaPluralTranslateKey } from 'mova-i18n';

export const LANGS: Record<TankerLang, MovaLang> = {
    en: 'en',
    ru: 'ru',
    cs: 'cs',
};

export const MOVA_LANGS: Record<MovaLang, TankerLang> = Object.keys(LANGS).reduce((memo, lang) => {
    memo[LANGS[lang]] = lang;

    return memo;
}, {} as Record<MovaLang, TankerLang>);

export const LANGS_PLURALS: Record<
    TankerLang,
    Partial<Record<keyof TankerKeysetTranslatePayload, MovaPluralTranslateKey>>
> = {
    en: {
        singular_form: 'one',
        few_form: 'other',
        zero_form: 'zero',
    },
    ru: {
        singular_form: 'one',
        few_form: 'few',
        many_form: 'many',
        zero_form: 'zero',
    },
    cs: {
        singular_form: 'one',
        few_form: 'few',
        other_form: 'other',
        zero_form: 'zero',
    },
};
