const chalk = require('chalk');

const COLORS = {
    error: 'red',
    warn: 'yellow',
    info: 'green',
    log: undefined,
};

function message(level = 'log', ...params) {
    let color = COLORS[level];

    // eslint-disable-next-line no-console
    console[level](`[${new Date().toISOString()}]`, ...params.map((val) => (color ? chalk[color](val) : val)));
}

function log(...params) {
    message('log', ...params);
}

function info(...params) {
    message('info', ...params);
}

function warn(...params) {
    message('warn', ...params);
}

function error(...params) {
    message('error', ...params);
}

module.exports = {
    logger: {
        log,
        info,
        warn,
        error,
    },
};
