import type { MovaPluralTranslateLangBe } from './plurals/langs/be';
import type { MovaPluralTranslateLangCs } from './plurals/langs/cs';
import type { MovaPluralTranslateLangRu } from './plurals/langs/ru';
import type { MovaPluralTranslateLangEn } from './plurals/langs/en';
export declare type MovaLang = 'en' | 'be' | 'cs' | 'ru';
export declare type MovaPluralTranslateKey = 'zero' | 'one' | 'two' | 'few' | 'many' | 'other';
export declare type MovaTranslate<T> = string | T;
export declare type MovaTranslateMeta = Partial<Record<string, any>> & {
    context?: string;
};
export declare type MovaTranslates<K extends string = string> = Record<
    K,
    Partial<{
        _meta: MovaTranslateMeta;
        en: MovaTranslate<MovaPluralTranslateLangEn>;
        be: MovaTranslate<MovaPluralTranslateLangBe>;
        ru: MovaTranslate<MovaPluralTranslateLangRu>;
        cs: MovaTranslate<MovaPluralTranslateLangCs>;
    }>
>;
export declare type MovaPlural<K extends MovaPluralTranslateKey> = (count: number) => K;
export declare type MovaPlurals = Partial<{
    en: MovaPlural<keyof MovaPluralTranslateLangEn>;
    be: MovaPlural<keyof MovaPluralTranslateLangBe>;
    ru: MovaPlural<keyof MovaPluralTranslateLangRu>;
    cs: MovaPlural<keyof MovaPluralTranslateLangCs>;
}>;
