import { MovaTranslates, MovaWatcherInternalConfig } from 'types';
import { parseCodeFile } from 'lib/parseCodeFile';
import { extractStoreTranslates } from 'lib/extractStoreTranslates';

export async function parseStoreFile(
    filename: string,
    config: MovaWatcherInternalConfig,
    logger: (filename: string, time: number) => void,
): Promise<MovaTranslates | undefined> {
    if (config.include && config.include.every((path) => !filename.startsWith(path))) {
        return;
    }

    if (config.exclude && config.exclude.some((path) => filename.startsWith(path))) {
        return;
    }

    if (filename.endsWith('.i18n.ts')) {
        const start = Date.now();

        const ast = await parseCodeFile(filename);
        const translates = extractStoreTranslates(ast);

        logger(filename, Date.now() - start);

        return translates;
    }
}
