import { MovaTranslates, MovaTranslateValue } from 'types';

function defaultStoreTemplate(translates: MovaTranslates): string {
    return `
import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset(${JSON.stringify(translates, null, 4)});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
`.trim();
}

export function storeTemplate(nextTranslates: Array<[string, MovaTranslateValue]>): string {
    const translates = nextTranslates
        .sort((a, b) => {
            return a[0].localeCompare(b[0]);
        })
        .reduce((memo: MovaTranslates, [key, value]) => {
            memo[key] = value;
            return memo;
        }, {});

    return defaultStoreTemplate(translates);
}
