import { createHash } from 'crypto';
import { MovaTranslateValue } from 'types';

function hash(data: any, len: number = 8): string {
    return createHash('sha1').update(JSON.stringify(data)).digest('hex').slice(0, len);
}

export function translateHash(data: MovaTranslateValue): string {
    return hash({ ...data, _meta: undefined });
}
