const path = require('path');

const rootDir = path.resolve(__dirname, '..', '..');
const cloud = process.env.DM_DEPLOY_CLOUD || 'yandex';
const prj = process.env.DM_DEPLOY_PRJ;
const profile = process.env.DM_DEPLOY_PROFILE;

const version = process.env.DM_VERSION;

if (!['yandex', 'amazonaws'].includes(cloud)) {
    throw new Error('Invalid DM_DEPLOY_CLOUD: ' + cloud);
}

if (!['web', 'storybook'].includes(prj)) {
    throw new Error('Invalid DM_DEPLOY_PRJ: ' + prj);
}

if (!['pr', 'test', 'crowd', 'prod'].includes(profile)) {
    throw new Error('Invalid DM_DEPLOY_PROFILE: ' + profile);
}

let staticConfig;
let s3Config;

if (profile === 'prod') {
    if (!version) {
        throw new Error('Invalid DM_VERSION: ' + version);
    }

    // prod
    staticConfig = {
        bucket: cloud === 'amazonaws' ? 'vlootkit-frontend' : 'drivematics',
        useYastaticCdn: true,
        static: {
            path: path.resolve(rootDir, 'dist/' + prj),
            target: 'v' + version + '/',
            sources: ['**/*'],
            ignore: ['**/*.{gz,br,map}', '**/stats.json'],
            overwrite: false,
            // TODO: compare files md5 hashsum for detect collisions
            throwOnOverwrite: false,
        },
    };
} else {
    // internal
    let prefix = profile + '/';
    if (profile === 'pr') {
        prefix = 'pr-' + process.env.CI_PULL_REQUEST_ID + '/';
    }

    staticConfig = {
        bucket: 'drivematics-test',
        useYastaticCdn: false,
        static: {
            path: path.resolve(rootDir, 'dist/' + prj),
            target: prefix + prj,
            sources: ['**/*'],
            ignore: ['**/*.{gz,br}', '**/stats.json'],
            overwrite: true,
            // TODO: compare files md5 hashsum for detect collisions
            throwOnOverwrite: false,
        },
    };
}

if (cloud === 'amazonaws') {
    s3Config = {
        accessKeyId: process.env.AMAZONAWS_S3_ACCESS_KEY_ID,
        secretAccessKey: process.env.AMAZONAWS_S3_SECRET_ACCESS_KEY,
        endpoint: 's3.eu-central-1.amazonaws.com',
    };
} else {
    s3Config = {
        accessKeyId: process.env.S3_ACCESS_KEY_ID,
        secretAccessKey: process.env.S3_SECRET_ACCESS_KEY,
    };
}

module.exports = {
    ...staticConfig,
    service: 'drivematics',
    s3: s3Config,
};
