#!/usr/bin/env node

const path = require('path');
const fs = require('fs');
const glob = require('glob');

const BASE_PATH = path.resolve(path.join(__dirname, '../../src'));
const DST_PATH = path.resolve(path.join(__dirname, '../../dist/storybook/__cache__'));

function buildFixtures() {
    const fixtures = glob.sync(`${BASE_PATH}/@(pages|widgets|features|entities|shared)/**/__fixtures__/*.json`);

    for (let fixture of fixtures) {
        const dstPath = path.resolve(path.join(DST_PATH, fixture.replace(BASE_PATH, '')));
        const dstDir = path.dirname(dstPath);

        fs.mkdirSync(dstDir, { recursive: true, mode: 0o755 });
        fs.copyFileSync(fixture, dstPath);
    }
}

buildFixtures();
