const path = require('path');
const webpack = require('webpack');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const webpackCommonConfig = require('../webpack/webpack.common');

module.exports = {
    typescript: { reactDocgen: 'react-docgen' },
    // stories: ['../../src/**/*.story.@(tsx|ts)'],
    stories: ['../../src/@(pages|widgets|features|entities|shared)/**/*.story.@(tsx|ts)'],
    core: {
        builder: 'webpack5',
    },
    addons: ['@storybook/addon-links', '@storybook/addon-essentials', 'storybook-addon-pseudo-states'],
    webpackFinal: (config) => {
        return {
            ...config,
            plugins: [
                ...config.plugins.filter((plugin) => {
                    return !(plugin instanceof webpack.DefinePlugin);
                }),
                new MiniCssExtractPlugin({
                    filename: '[name].[contenthash].css',
                    chunkFilename: '[name].[contenthash].css',
                    ignoreOrder: true,
                }),
                new webpack.DefinePlugin({
                    'process.env.DM_VERSION': JSON.stringify(process.env.DM_VERSION),
                    'process.env.DM_BACKEND_CLUSTER': JSON.stringify(process.env.DM_BACKEND_CLUSTER),
                    'process.env.DM_CACHE_REQUEST': JSON.stringify(process.env.DM_CACHE_REQUEST || 'readonly'),
                }),
            ],
            module: {
                ...config.module,
                rules: webpackCommonConfig().module.rules,
            },
            resolve: {
                ...config.resolve,
                modules: [path.resolve(__dirname, '..', '..', 'src'), 'node_modules'],
            },
        };
    },
};
