const fs = require('fs');
const path = require('path');

const bodyParser = require('body-parser');
const { createProxyMiddleware } = require('http-proxy-middleware');

const { backendHost } = require('../consts');

const BASE_PATH = path.resolve(__dirname, '../../src');

function buildFixturePath(path) {
    return path.replace(/^\/?__cache__/, BASE_PATH);
}

// https://oauth.yandex.ru/authorize?response_type=token&client_id=ee2a628eb96d40a9807fe7d57b357474
const OAUTH_TOKEN_PATH = path.resolve(path.join(BASE_PATH, '../secrets/oauth'));
const OAUTH_TOKEN = process.env.DM_OAUTH_TOKEN || fs.readFileSync(OAUTH_TOKEN_PATH, 'utf-8').trim();

module.exports = (router) => {
    router.get('/__cache__/*', async function (req, res, next) {
        const filename = buildFixturePath(req.path);

        if (fs.existsSync(filename)) {
            const payload = JSON.parse(fs.readFileSync(buildFixturePath(req.path), 'utf-8'));

            try {
                return res.json(payload);
            } catch (error) {
                console.error(error);
            }
        }

        res.status(404).json({ status: 404 });
    });

    router.post('/__cache__/*', bodyParser.json(), async function (req, res, next) {
        const filename = buildFixturePath(req.path);

        fs.mkdirSync(path.dirname(filename), { recursive: true, mode: 0o755 });
        fs.writeFileSync(buildFixturePath(req.path), JSON.stringify(req.body, null, 2), {
            encoding: 'utf-8',
            mode: 0o644,
        });

        res.json({ status: 'ok' });
    });

    router.use(
        '/api',
        createProxyMiddleware({
            target: 'https://' + backendHost,
            changeOrigin: true,
            secure: false,
            onProxyReq(req) {
                req.setHeader('Authorization', 'OAuth ' + OAUTH_TOKEN);
            },
        }),
    );

    router.use(
        '/suggest-geo',
        createProxyMiddleware({
            target: 'https://suggest-maps.yandex.ru',
            changeOrigin: true,
            secure: false,
        }),
    );
};
