import { withHermione } from 'hermione-storybook';
import { withDate } from '../../src/tests/storybook/decorators/withDate';
import { withLayout } from '../../src/tests/storybook/decorators/withLayout';
import { withFlags } from '../../src/tests/storybook/decorators/withFlags';
import { withRequestCache } from '../../src/tests/storybook/decorators/withRequestCache';
import { withSuspense } from '../../src/tests/storybook/decorators/withSuspense';

export const parameters = {
    actions: { argTypesRegex: '^on[A-Z].*' },
    backgrounds: {
        default: 'gray',
        values: [
            { name: 'white', value: '#fff' },
            // --color-gray-20
            { name: 'gray', value: '#f2f5f9' },
            { name: 'black', value: '#000' },
        ],
    },
    controls: {
        matchers: {
            color: /(background|color)$/i,
            date: /Date$/,
        },
    },
};

export const decorators = [withHermione(), withSuspense, withLayout, withDate, withFlags, withRequestCache];
