const path = require('path');
const WebpackNotifierPlugin = require('webpack-notifier');
const { lang, service, backendHost } = require('../consts');

module.exports = function webpackDevConfig(config) {
    // yav secret: ssl cert
    const pem =
        service === 'vlootkit' ? config.tokens['localhost.vlootkit.com.pem'] : config.tokens['localhost.yandex.ru.pem'];
    const hosts =
        service === 'vlootkit' ? ['localhost.vlootkit.com', 'localhost.vlootkit.cz'] : ['localhost.yandex.ru'];

    const extraProxy =
        service === 'vlootkit'
            ? {
                  '/auth': {
                      target: 'https://vlootkit.com',
                      changeOrigin: true,
                      secure: false,
                  },
                  '/auth/*': {
                      target: 'https://vlootkit.com',
                      changeOrigin: true,
                      secure: false,
                  },
              }
            : {};

    return {
        plugins: [
            new WebpackNotifierPlugin({
                excludeWarnings: true,
                title: 'Webpack',
            }),
        ],
        devtool: 'eval-cheap-module-source-map',
        devServer: {
            allowedHosts: hosts,
            static: {
                directory: path.join(__dirname, 'dist'),
            },
            client: {
                overlay: true,
            },
            historyApiFallback: {
                rewrites: [{ from: /(.+)?/, to: `/pages/${service}/${lang}/index.html` }],
            },
            compress: true,
            port: 8000,
            host: '0.0.0.0',
            https: {
                key: pem,
                cert: pem,
            },
            headers: {
                'Cache-Control': 'max-age=31536000',
            },
            proxy: {
                '/passport/*': {
                    target:
                        service === 'vlootkit'
                            ? 'https://vlootkit.com/auth/api/user'
                            : 'https://api.passport.yandex.ru/accounts',
                    changeOrigin: true,
                    secure: false,
                    pathRewrite: {
                        '^/passport/': '',
                    },
                },
                '/api/*': {
                    target: `https://${backendHost}`,
                    changeOrigin: true,
                    secure: false,
                },
                '/suggest-geo': {
                    target: `https://suggest-maps.yandex.ru`,
                    changeOrigin: true,
                    secure: false,
                },
                ...extraProxy,
            },
        },
    };
};
