const CssMinimizerPlugin = require('css-minimizer-webpack-plugin');

const TerserPlugin = require('terser-webpack-plugin');

module.exports = {
    devtool: 'hidden-source-map',
    optimization: {
        minimize: true,
        runtimeChunk: 'single',
        minimizer: [
            new CssMinimizerPlugin({
                minimizerOptions: {
                    preset: [
                        'default',
                        {
                            discardComments: { removeAll: true },
                        },
                    ],
                },
            }),
            new TerserPlugin({
                test: /(\.tsx?$|\.js(\?.*)?$)/i,
            }),
        ],
    },
};
