module.exports = {
    env: {
        browser: true,
        es6: true,
    },
    globals: {
        Atomics: 'readonly',
        SharedArrayBuffer: 'readonly',
    },
    parser: '@typescript-eslint/parser',
    parserOptions: {
        ecmaFeatures: {
            jsx: true,
        },
        ecmaVersion: 11,
        sourceType: 'module',
    },
    plugins: ['react', '@typescript-eslint', 'simple-import-sort', 'react-hooks'],
    extends: ['plugin:react/recommended', 'plugin:drivematics/all'],
    rules: {
        curly: 'error',
        'no-debugger': 'error',
        'no-eval': 'error',
        'no-console': [
            'error',
            {
                allow: ['warn', 'error', 'info', 'dir', 'clear'],
            },
        ],
        'no-dupe-args': 'error',
        'no-duplicate-imports': 'error',
        'newline-before-return': 'warn',
        '@typescript-eslint/no-unused-vars': [
            'error',
            {
                vars: 'all',
                args: 'none',
            },
        ],
        '@typescript-eslint/no-magic-numbers': [
            'error',
            {
                ignore: [-1, 0, 1, 2, 100],
                ignoreEnums: true,
            },
        ],
        'no-warning-comments': ['error', { terms: ['BIB'] }], // bring it back
        'react/jsx-key': 'error',
        'react/display-name': 'off',
        'react/prop-types': 'off',
        'react/no-unescaped-entities': 'off',
        'react/no-children-prop': 'off',
        'react/jsx-no-target-blank': 'off',
        'react/jsx-curly-brace-presence': ['error', { props: 'never', children: 'never' }],
        'react-hooks/exhaustive-deps': 'warn',
        'no-restricted-imports': [
            'warn',
            {
                patterns: ['**/request-helper/*'],
            },
        ],
        'simple-import-sort/imports': [
            'warn',
            {
                groups: [
                    // Node.js builtins. You could also generate this regex if you use a `.js` config
                    // For example: `^(${require("module").builtinModules.join("|")})(/|$)`
                    [
                        '^node:',
                        '^(assert|buffer|child_process|cluster|console|crypto|dgram|dns|domain|events|fs|http|https|module|net|os|path|punycode|querystring|readline|repl|stream|string_decoder|sys|timers|tls|tty|url|util|vm|zlib|freelist|v8|process|async_hooks|http2|perf_hooks)(/.*|$)',
                    ],
                    // Packages. `react` related packages come first
                    ['^react', '^@?\\w'],
                    // Side effect imports.
                    ['^\\u0000'],

                    // Deprecated folders
                    ['^constants/'],
                    ['^contexts/'],
                    ['^hooks/'],
                    ['^utils/'],

                    // Storybook/Hermione/Jest helpers end ect.
                    ['^tests/'],

                    // Feature-Sliced
                    ['^processes/'],
                    ['^pages/'],
                    ['^widgets/'],
                    ['^features/'],
                    ['^entities/'],
                    ['^shared/'],
                    ['^components/'],
                    // Parent imports. Put `..` last
                    ['^\\.\\.(?!/?$)', '^\\.\\./?$'],
                    // Other relative imports. Put same-folder imports and `.` last
                    ['^\\./(?=.*/)(?!/?$)', '^\\.(?!/?$)', '^\\./?$'],
                    // Translates imports
                    ['^.+\\.i18n$'],
                    // Images imports
                    ['^.+\\.ico$', '^.+\\.jpg$', '^.+\\.png$', '^.+\\.svg$'],
                    // Styles imports
                    ['^.+\\.s?css$'],
                ],
            },
        ],
    },
    settings: {
        react: {
            pragma: 'React',
            version: 'detect',
        },
    },
};
