const LANGS = ['en', 'ru'];

if (!process.env.LANG || !LANGS.includes(process.env.LANG)) {
    process.env.LANG = 'en';
}

module.exports = {
    testEnvironment: 'jsdom',
    globals: {
        'ts-jest': {
            diagnostics: false,
            isolatedModules: true,
        },
    },
    transform: {
        '.(ts|tsx)': 'ts-jest',
    },
    testPathIgnorePatterns: ['/node_modules/', '/lib/'],
    moduleDirectories: ['node_modules', 'src'],
    testMatch: ['<rootDir>/src/**/*.test.{ts,tsx}'],
    moduleFileExtensions: ['js', 'json', 'ts', 'tsx'],
    coverageDirectory: '<rootDir>/__reports/report-unit-coverage',
    collectCoverageFrom: ['src/**/*.{ts,tsx}'],
    coverageReporters: ['lcov', 'text-summary', 'html'],
    coverageThreshold: {
        global: {
            statements: 0,
            branches: 0,
            functions: 0,
            lines: 0,
        },
    },
    reporters: [
        'default',
        [
            'jest-html-reporters',
            {
                publicPath: '__reports/report-unit',
                filename: 'index.html',
            },
        ],
    ],
    moduleNameMapper: {
        '\\.(css|less|svg|png)$': 'identity-obj-proxy',
    },
    setupFilesAfterEnv: ['<rootDir>/setupTests.js'],
    preset: 'ts-jest',

    haste: {
        // improve file search for arc project
        // https://jestjs.io/docs/configuration#haste-object
        // @ts-ignore
        forceNodeFilesystemAPI: true,
    },
};
