import React from 'react';
import ReactDOM from 'react-dom';
import { YMInitializer } from 'react-yandex-metrika';

import { getCookie } from 'shared/helpers/getCookie/getCookie';

import Content from 'components/Content';
import GlobalErrorHandler from 'components/GlobalErrorHandler';

import 'yandex-font/build/static/browser.css';
import 'shared/styles/global/reset.css';
import 'shared/styles/variables/common.css';
import 'shared/styles/variables/desktop.css';

// @todo: add metrika for testing
const m_id = 72299971;
const UserIDKey = 'yandex_login';

function legacyHashRouterUrlRedirect() {
    const hash = window.location.hash;

    if (hash) {
        window.history.replaceState({}, '', hash[0] === '#' ? hash.slice(1) : hash);
    }
}

legacyHashRouterUrlRedirect();

function App() {
    return (
        <GlobalErrorHandler>
            {!origin.includes('localhost') && (
                <YMInitializer
                    accounts={[m_id]}
                    options={{
                        webvisor: false,
                        userParams: { UserID: getCookie(UserIDKey) },
                    }}
                    version="2"
                />
            )}
            <Content />
        </GlobalErrorHandler>
    );
}

ReactDOM.render(<App />, document.getElementById('main'));
