import React from 'react';
import ReactDOM from 'react-dom';
import { BrowserRouter as Router } from 'react-router-dom';

import { getLang } from 'utils/language/getLang';

import ErrorForbiddenView from 'components/ErrorView/403';

import 'yandex-font/build/static/browser.css';
import style from 'components/Content/index.css';

function App403() {
    return (
        <div className={style.content}>
            <Router>
                <ErrorForbiddenView
                    forceLang={getLang()}
                    buttonHandler={() => {
                        window.location.reload();
                    }}
                />
            </Router>
        </div>
    );
}

ReactDOM.render(<App403 />, document.getElementById('main'));
