import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Available area': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Available area',
        ru: 'Доступная зона',
        cs: 'Dostupná oblast',
    },
    'Restricted area': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Restricted area',
        ru: 'Запрещённая зона',
        cs: 'Omezená oblast',
    },
    'Unknown area': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unknown area',
        ru: 'Неизвестная зона',
        cs: 'Neznámá oblast',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
