import React from 'react';

import { EMPTY_DATA } from 'constants/constants';

import { i18n } from 'components/Cars/AreaStatus/index.i18n';

import style from 'components/Cars/AreaStatus/index.css';

export enum AreaStatuses {
    UNKNOWN = 'unknown',
    AVAILABLE = 'available',
    RESTRICTED = 'restricted',
}

interface IAreaStatusProps {
    status?: AreaStatuses;
}

export const AreaStatus = (props: IAreaStatusProps) => {
    let { status = AreaStatuses.UNKNOWN } = props;

    let text: string | null = null;

    let availableStatuses: string[] = Object.values(AreaStatuses);
    if (!availableStatuses.includes(status)) {
        status = AreaStatuses.UNKNOWN;
    }
    switch (status) {
        case AreaStatuses.UNKNOWN:
            text = i18n('Unknown area');
            break;
        case AreaStatuses.AVAILABLE:
            text = i18n('Available area');
            break;
        case AreaStatuses.RESTRICTED:
            text = i18n('Restricted area');
            break;
    }

    return (
        <div className={`${style.area_status} ${style?.[status]}`}>
            <div className={style.icon} />
            {text ?? EMPTY_DATA}
        </div>
    );
};
