import React from 'react';

import { ONE_SECOND, ONE_WEEK } from 'constants/constants';

import { buildWeekData } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Mileage/buildWeekData';
import { ICarCardInformersChartProps, SENSORS } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/types';
import useSensorsData from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/useSensorsData';
import Informer from 'components/Informer';

import { i18n } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/Mileage/MileageAllInformer.i18n';

export default function MileageAllInformer({ className, car_id, type, hideHeader }: ICarCardInformersChartProps) {
    let locale = 'ru';

    let [isLoading, , chart_data, getSensor] = useSensorsData<any>({
        handler: (data) => {
            return buildWeekData(data?.sensors?.[0].values || []) || [];
        },
    });

    React.useEffect(() => {
        car_id &&
            getSensor({
                car_id,
                since: Math.trunc((+new Date() - ONE_WEEK) / ONE_SECOND),
                until: Math.trunc(+new Date() / ONE_SECOND),
                sensor_id: SENSORS.MILEAGE,
            });
    }, [car_id]);

    let max: string | number = +chart_data?.[chart_data.length - 1]?.y || 0;
    let maxLabel = Math.round(max).toLocaleString(locale);

    return (
        <Informer
            className={className}
            data={chart_data}
            type={type}
            title={i18n('Mileage')}
            isLoading={isLoading}
            value={`${maxLabel} ${i18n('km')}`}
            hideHeader={hideHeader}
        />
    );
}
