import { DAYS_IN_WEEK, ONE_DAY, ONE_SECOND } from 'constants/constants';

import { dateToShortString } from 'utils/dateToShortString';
import { sortInformersDate } from 'utils/informers/sortInformersDate';

import { ISensorsHistoryValueItem } from 'components/Cars/CarCard/CarCardOverview/CarCardInformers/types';

export const buildWeekData = (data: ISensorsHistoryValueItem[]): any[] => {
    let days: Record<string, { timestamp: number; value: number[] }> = {};
    let currentDay = Date.now();

    for (let i = 0; i <= DAYS_IN_WEEK; i++) {
        let timestamp = currentDay - ONE_DAY * i;
        let key = dateToShortString(timestamp);

        days[key] = { timestamp, value: [] };
    }

    data.forEach((el: { value: number; timestamp: number }) => {
        let value = el.value;
        let timestamp = el.timestamp * ONE_SECOND;
        let key = dateToShortString(timestamp);

        if (value > 0 && days[key]) {
            days[key].value.push(value);
        }
    });

    let arr = Object.values(days).sort(sortInformersDate);

    let result: { x: string; y: number }[] = [];

    arr.forEach(({ timestamp, value }, i) => {
        let length = value.length;
        let first = value[0] || 0;
        let last = value[length - 1] || 0;
        let x = dateToShortString(timestamp);

        if (i === 0) {
            if (first) {
                result.push({
                    x,
                    y: first,
                });
            }
        } else {
            if (length) {
                result.push({
                    x,
                    y: last,
                });
            } else {
                let prev = result[result.length - 1];

                prev &&
                    result.push({
                        x,
                        y: prev.y,
                    });
            }
        }
    });

    return result;
};
