import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Engine hours': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'EXPIRED',
            },
        },
        en: 'Engine hours',
        ru: 'Моточасы в сутки',
        cs: 'Motohodiny',
    },
    h: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'h',
        ru: 'ч',
        cs: 'h',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
